;**********************************************
; Test Matrix Switch 4x4 
; Hardware  : CP-PIC V3.0/V4.0
; file name : Key_4x4
; OSC       : 10 MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaolop
; Company   : ETT  CO.,LTD.
; Date      : 8/8/2002
;**********************************************
; STEP to follow when test this program
;    1.Connect RS232 cable between board and PC.
;    2.Connect keyboard SW matrix 4x4 
;
;	  row 1     connect to RB4
;	  row 2     connect to RB5
;	  row 3     connect to RB6
;	  row 4     connect to RB7
;	  column 1  connect to RD0
;	  column 2  connect to RD1
;	  column 3  connect to RD2
;	  column 4  connect to RD3
;
;    3.Download this program to CPU.
;    4.Run terminal program such as Procom plus,XTALK etc.
;    5.Set parameter Procom plus to 9600 baud,No parity,8 bits data and 1 bit. stop
;    6.Reset board ,after reset board you will see this message on PC.
;
;	        "Keyboard 4x4"
;
;    7.Press any key on keyboard, you will see the key that you pressed.
;**********************************************


	     list p=18f458                 ; list directive to define processor
	     #include <p18f458.inc>        ; processor specific variable definitions

	offset    EQU       0x20
	count     EQU       0x21
	colm	  EQU	    0x22
	dt1       EQU       0x23
	dt2       EQU       0x24
	dt3       EQU       0x25
	da_ta	  EQU       0x26

	          ORG       0x0000

;************ initial *******************
init      clrf      TRISD	   ; PORT D as output
	  setf	    TRISB	   ; PORT B as input

	  bcf	    INTCON2,RBPU   ; enable pull-up PORT B		  
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive
          bsf       TXSTA,TXEN     ; Transmit enable
          BSF	    TXSTA,BRGH	   ; HI SPEED
	  	  
;********** start to send **********************

          clrf      offset         ; load offset of character table
	  call	    delay
start     movf      offset,w       
          call      TAB	           ; get data form table
          addlw     0              ; Character = 00 ?
          btfsc     STATUS,Z       ; Character = 00 ?
          goto      scan           ; Yes , Z = 1
                                   ; No  , Z = 0
	  call	    send

          incf      offset,f       
	  incf	    offset,f	   ; inc pointer
          goto      start          ; Send again

scan	  movlw	    0xfe	   ; start data to scan column "11111110"
	  movwf	    colm
	  clrf	    count	   ; count = 00
scan1	  movff	    colm,PORTD     ; scan column as PORT D
	  btfss	    PORTB,4	   ; test key Row 1 skip "1"
	  goto	    row_1	   
	  btfss	    PORTB,5	   ; test key Row 2 skip "1"	   
	  goto	    row_2
	  btfss	    PORTB,6	   ; test key Row 3 skip "1"
	  goto	    row_3
	  btfss	    PORTB,7	   ; test key Row 4 skip "1"
	  goto	    row_4
	  movlw	    .8		   
	  clrc			   ; clear carry flag
	  addwf     count,f	   ; count = count + 8 
	  rlncf	    colm,f	   ; rotate data to scan next column
	  btfsc	    colm,4	   ; test last column (column 4)
	  goto	    scan1	   ; next scan
	  goto	    scan	   ; start scan
	  
row_4	  movlw     .6  	   ; offset to table
	  addwf	    count,w        ; w = count + 6
	  goto      display

row_3	  movlw     .4		   ; offset to table
	  addwf	    count,w	   ; w = count + 4
	  goto      display

row_2	  movlw     .2		   ; offset to table
	  addwf	    count,w	   ; w = count + 2
	  goto      display
	  
row_1	  movf	    count,w        ; offset to w
	    
display	  call	    TAB_KEY        ; get data form table 
	  call	    send	   ; send data to rs232
	  call	    delay	   
	  goto	    scan	   ; next to scan

send      movwf     TXREG          ; Send recent data to TX 
wait1     LFSR      0,TXSTA        ; 
          btfss     INDF0,1        ; check TRMT bit in TXSTA (FSR)
          goto      wait1          ; TXREG full  or TRMT = 0	  
	  return

delay     movlw	    3
	  movwf	    dt1
sd3	  clrf      dt2
sd2       clrf      dt3
sd1       decfsz    dt3
          goto      sd1
          decfsz    dt2
          goto      sd2
	  decfsz    dt1
	  goto      sd3
          return

;********* Tebel of message ********************  

TAB       addwf     PCL,f           ; Move offset to PC lower

	  DT	    0x0C,"Keyboard 4x4",0XA,0XD,0X0

TAB_KEY   addwf	    PCL,f
	 
	  DT	   "1","2","3","4","5","6","7","8","9","0","A","B","C","D","E","F"

  END
